<?php
//$colors=array('#330000','#660000','#990000','#b30000','#e60000','#ff3333','#ff6666','#ff9999','#ffb3b3','#ffcccc');
//$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
//$colors=array('#01B8AA', '#374649', '#F2C80F', '#FD625E', '#A66999', '#DFBFBF', '#8AD4EB', '#FE9666', '#5F6B6D', '#AD514A', '#7BB252');

add_shortcode('entradas_borradas', 'mostrar_entradas_borradas');
function mostrar_entradas_borradas( $atts, $content = null  )
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"delete");
	if($recs)

		return loop_query( array('post__in'=>$recs,'post_type'=>array('post')) , false,true );
		else return get_template_part( 'all-read', 'index' );
}

function get_color_sequence(){
	$my_theme=wp_get_theme();
	$name=$my_theme->get( 'Name' ) ;
	$colors =array('#330000','#660000','#990000','#b30000','#e60000','#ff3333','#ff6666','#ff9999','#ffb3b3','#ffcccc');
	
	if (strpos($name, 'incrustado') !== false) {
		$colors=array('#01B8AA', '#374649', '#F2C80F', '#FD625E', '#A66999', '#DFBFBF', '#8AD4EB', '#FE9666', '#5F6B6D', '#AD514A', '#7BB252');
		
	} else {
		$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
	}
	return $colors;
}

function get_positive_color_sequence(){
	$colors=array('#001a00','#003300','#004d00','#008000','#009900','#00cc00','#00e600','#1aff1a','#66ff66',' #99ff99');
	return $colors;	
}
function get_negative_color_sequence(){
	$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
	return $colors;
}

add_shortcode('recomendaciones', 'mostrar_recomendaciones');
function mostrar_recomendaciones( $atts, $content = null  )
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"recommended");
	if($recs)
		return loop_query( array('post__in'=>$recs,'post_type'=>array('post','project')) , false );
		else return get_template_part( 'all-read', 'index' );
}

add_shortcode('favoritos', 'mostrar_favoritos');
function mostrar_favoritos( $atts, $content = null  )
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"favorite");
	if($recs)
		return loop_query( array('post__in'=>$recs,'post_type'=>array('post','project')) , false );
		else return get_template_part( 'all-read', 'index' );
}
add_shortcode('borrados', 'mostrar_borrados');
function mostrar_borrados( $atts, $content = null  )
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"delete");
	if($recs)
		return loop_query( array('post__in'=>$recs,'post_type'=>array('post','project')) , false );
		else return get_template_part( 'all-read', 'index' );
}
function loop_query( $args, $filtrar_por_categorias_usuario = true,  $mostrar_borrados = false )
{

	ob_start();
	$args['nopaging']=false;
	$args['posts_per_page']=1000;
	$args['date_query']   = array(
			'column'  => 'post_date',
			'after'   => '- 180 days'
	);
	$args['no_found_rows']=true;
	$now = new DateTime('NOW');
	$condicion1=false;
	if(isset($args['post__in']) && !count($args['post__in']))$condicion=true;
	$max_days = intval(get_option('ainia_max_days'));
	$max_posts = intval(get_option('ainia_max_posts'));
	$cuantos = 0;
	$last_plazo = "";
	if(!$filtrar_por_categorias_usuario)
	 remove_filter('pre_get_posts', array("User_Categories", 'filtrar_por_concepto'));
	 $the_query = new WP_Query( $args );
	 if ( $the_query->have_posts() && !$condicion1 ) {
	 	while ( $the_query->have_posts() ) {
	 		$the_query->the_post();
	 		/*	$day = new DateTime(get_the_date('d-m-Y'));
	 		 $dif = $day->diff($now);
	 		 $condicion1 = $max_days ? $dif->days<$max_days : true ;
	 		 $condicion2 = $max_posts ? $cuantos<$max_posts : true ;
	 		 $condicion3 = $filtrar_por_categorias_usuario ? is_post_in_user_categories(get_the_ID()) : true;
	 		 if($condicion3 && $condicion1 && $condicion2)
	 		 {
	 			if($dif->days >= 365 )$plazo="Hace más de un año";
	 			else if($dif->days >= 60  )$plazo="Hace más de dos meses";
	 			else if($dif->days >= 31  )$plazo="Hace más de un mes";
	 			else if($dif->days >= 14  )$plazo="Hace más de dos semanas";
	 			else if($dif->days >= 7   )$plazo="Hace más de una semana";
	 			else if($dif->days >= 3   )$plazo="Durante la última semana";
	 			else if($dif->days == 2   )$plazo="Anteayer";
	 			else if($dif->days == 1   )$plazo="Ayer";
	 			else $plazo="Hoy";
	 			if($plazo != $last_plazo){
	 			echo "<h3 class='date-separator'>".$plazo."</h3>";
	 			$last_plazo = $plazo;
					}
					get_template_part( 'content', get_post_format() );
					$cuantos+=1;
					}*/
	 		//$post=$the_query->the_post();
	 		$rel = get_user_relation_id( get_current_user_id() , 0, get_the_ID(), 'delete' );

	 		if( !$rel || $mostrar_borrados){
	 			get_template_part( 'content', get_post_format() );
	 		}
	 	}
	 }

	 if(!$cuantos) get_template_part( 'all-read', 'index' );

	 wp_reset_postdata();
	 $buffer = ob_get_contents();
	 ob_end_clean();
	 return $buffer;
}
add_shortcode('grid_graficos_modulos','grid_graficos_modulos_shortcode');
function grid_graficos_modulos_shortcode()
{
	?>
<b>- Información relativa a los últimos 90 días -</b><br><br>

	<script>
		jQuery(document).ready(function run_module_graphics($)
		{	
			var grafica_entradas_x_modulo = function()
			{
				//$('#graficos_modulos').css('border','1px solid #999');
				//$('#graficos_modulos').css('box-shadow','2px 2px 10px #999');
				
				var chart1 = new Highcharts.Chart({
					chart: {
						renderTo: 'graficos_modulos',
						type: 'pie',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					title: {
						text: 'Entradas por Módulo'
					},
					
					plotOptions: {
						pie: {
							innerSize: 100,
							depth: 45
						}
					},
					series: [{
						name: 'Entradas',
						data: [
							<?php		
							//start by fetching the terms for the scope taxonomy
							$terms = get_terms( 'scope', array(
								'orderby'    => 'count',
								'hide_empty' => 0
							) );
							
							$len = sizeof($terms);
							$today = getdate();
							// now run a query for each animal family
							foreach( $terms as $term ) {
							
								$queryArgs = array( 'scope' => $term->slug,
									'posts_per_page'=>-1
									);
								// Define the query
								$query = new WP_Query( $queryArgs );
								// output the post titles in a list
								
								$contador=0;
								// Start the Loop
								while ( $query->have_posts() ) : $query->the_post();
									$contador++;
								endwhile;?>
									
								<?php 
								echo '[\''.$term->slug.'\','.$contador.'],';
								// use reset postdata to restore orginal query
								wp_reset_postdata();
							}
							?>
						]
					}]
				});		
			}
		
			var grafica_entradas_x_tags = function run_module_graphics_4()
			{	
				<?php
					$categories = get_categories();
				?>
				//$('#graficos_modulos_3').css('border','1px solid #999');
			//	$('#graficos_modulos_3').css('box-shadow','2px 2px 10px #999');
				//$('#graficos_modulos_3').css('width','1003px');
				
				var chart3 = new Highcharts.Chart({
					chart: {
						renderTo: 'graficos_modulos_3',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					title: {
						text: 'Entradas por Tag'
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
									$myhashmap = array();
									foreach ( $categories as $category ) {
										
										$args = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days'))) 
										);
										
										$post_by_cat = get_posts($args);	
										$counter = 0;
										foreach($post_by_cat as $p)
										{
											$counter++;
										}
										
										if ($counter>0){

										$texto=str_replace("'","\'",$category->name);
										$myhashmap[$texto] = $counter;

										}
								
									}
									arsort($myhashmap);
									foreach (array_keys($myhashmap) as $key){
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].']}';
									}
							
									
									
									?>
						

						]
				});						
			}
			var grafica_entradas_x_fuente = function run_module_graphics_4()
			{	
				<?php
					$sources = get_terms("fuente");
				?>
				//$('#graficos_modulos_4').css('border','1px solid #999');
			//	$('#graficos_modulos_4').css('box-shadow','2px 2px 10px #999');
				//$('#graficos_modulos_3').css('width','1003px');
				
				var chart3 = new Highcharts.Chart({
					chart: {
						renderTo: 'graficos_modulos_4',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					title: {
						text: 'TOP 10 - Entradas por fuente'
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
									$myhashmap = array();
									foreach ( $sources as $source ) {
										
										
										$args = array(
											'fuente'		   => $source->slug,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days'))) 
										);
										
										
										$query = new WP_Query( $args );	
										$counter = 0;
										while ( $query->have_posts() ) : $query->the_post();
											$counter++;
										endwhile;
										
										if ($counter>0){

										$texto=str_replace("'","\'",$source->name);
										$myhashmap[$texto] = $counter;

										}
									wp_reset_postdata();
									}
									arsort($myhashmap);
									foreach (array_keys($myhashmap) as $key){
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].']}';
									}
							
									
									
									?>
						

						]
				});						
			}
			
		
			//Ocultamos los divs de gráficos
			
			$('#grafico_entradas_x_modulo').css('display','block');
			$('#grafico_dist_tags_x_modulo').css('display','block');
			$('#grafico_evolucion_tags').css('display','block');
			$('#grafico_entradas_tags').css('display','block');
		grafica_entradas_x_tags();
		grafica_entradas_x_fuente();
		
			
			$('#div_pieChart1').click(function()
			{
				$('#grafico_entradas_x_modulo').css('display','block');
				$('#grafico_dist_tags_x_modulo').css('display','none');
				$('#grafico_evolucion_tags').css('display','none');
				$('#grafico_entradas_tags').css('display','none');
				grafica_entradas_x_modulo();
			});
			
			$('#div_columnChart').click(function()
			{
				$('#grafico_entradas_x_modulo').css('display','none');
				$('#grafico_dist_tags_x_modulo').css('display','block');
				$('#grafico_evolucion_tags').css('display','none');
				$('#grafico_entradas_tags').css('display','none');
			});
			
			$('#div_pieChart2').click(function()
			{
				$('#grafico_entradas_x_modulo').css('display','none');
				$('#grafico_dist_tags_x_modulo').css('display','none');
				$('#grafico_evolucion_tags').css('display','none');
				$('#grafico_entradas_tags').css('display','block');
				grafica_entradas_x_tags();
			});
			
			$('#div_pieChart3').click(function()
			{
				$('#grafico_entradas_x_modulo').css('display','none');
				$('#grafico_dist_tags_x_modulo').css('display','none');
				$('#grafico_evolucion_tags').css('display','block');
				$('#grafico_entradas_tags').css('display','none');
				grafica_entradas_x_fuente();
			});
		});
		
		</script>
	<div id="grid_graficos_modulos">		
		


		<div id="grafico_dist_tags_x_modulo">
			
		</div>
		<div id="grafico_entradas_tags">
			
			<div id="graficos_modulos_3">
			
			</div>
		</div>
		<br>
		<br>
		<div id="grafico_evolucion_tags">
			
			<div id="graficos_modulos_4">
			
			</div>
		</div>
	</div>
	<?php
}
add_shortcode('grafico_entradas_x_fuente','grafico_entradas_x_fuente_shortcode');

function grafico_entradas_x_fuente_shortcode(){

	?>
	<div  style="position:relative;">
			<div id="grafico_fuente_semana" >
		<?php
		grafico_entradas_x_fuente_shortcode_semana();
		?>
		</div>
		<div id="grafico_fuente_mes" style="visibility:hidden;position:absolute;top:0;width:100%;">
			<?php
			grafico_entradas_x_fuente_shortcode_mes();
		?>
					</div>
					<div id="grafico_fuente_trimestre" style="visibility:hidden;position:absolute;top:0;width:100%;">
				<?php
				grafico_entradas_x_fuente_shortcode_trimestre();
		?>
					</div>
					</div>
				<?php

}

function grafico_entradas_x_fuente_shortcode_semana()
{
	menu_periodos_estadisticas_fuente();
	?>
<h3>TOP 10 - Entradas por fuente</h3> (Últimos 7 días)
			<?php
					$sources = get_terms("fuente");
				//	$colors=array('#01B8AA', '#374649', '#F2C80F', '#FD625E', '#A66999', '#DFBFBF', '#8AD4EB', '#FE9666', '#5F6B6D', '#AD514A', '#7BB252');
						
					$colors= get_color_sequence();
					$color_index=0;
					
					$myhashmap = array();
					foreach ( $sources as $source ) {
					
					
						$args = array(
								'fuente'		   => $source->slug,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days')))
						);
					
					
						$query = new WP_Query( $args );
						$counter = 0;
						while ( $query->have_posts() ) : $query->the_post();
						$counter++;
						endwhile;
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$source->name);
							$myhashmap[$texto] = $counter;
					
						}
						wp_reset_postdata();
					}
					$myhashmap_size = count($myhashmap);
					
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{	
			var grafica_entradas_x_fuente = function run_module_graphics_4()
			{	
	
			//	$('#graficos_modulos_4').css('border','1px solid #999');
				//$('#graficos_modulos_4').css('box-shadow','2px 2px 10px #999');
				//$('#graficos_modulos_3').css('width','1003px');
				
				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 67
					    },
					chart: {
						renderTo: 'graficos_modulos_4_semana',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
					
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
											
									}
							
									
									
									?>
						

						]
				});	
			
			}
			grafica_entradas_x_fuente();
		});
			</script>
				<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
		
			
			<div id="grafico_evolucion_tags">
			
			<div id="graficos_modulos_4_semana">
			
			</div>
		</div>

	<?php
}

function grafico_entradas_x_fuente_shortcode_mes()
{
	menu_periodos_estadisticas_fuente();
	?>
		<h3>TOP 10 - Entradas por fuente</h3>(Últimos 30 días)
			<?php
					$sources = get_terms("fuente");
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $sources as $source ) {
					
					
						$args = array(
								'fuente'		   => $source->slug,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-30 days')))
						);
					
					
						$query = new WP_Query( $args );
						$counter = 0;
						while ( $query->have_posts() ) : $query->the_post();
						$counter++;
						endwhile;
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$source->name);
							$myhashmap[$texto] = $counter;
					
						}
						wp_reset_postdata();
					}
					
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{	
			var grafica_entradas_x_fuente = function run_module_graphics_4()
			{	
	

				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 67
					    },
					chart: {
						renderTo: 'graficos_modulos_4',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
		
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}
																	
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											
											$max_results=$max_results+1;
									}
							
									
									
									?>
						

						]
				});						
			}
			grafica_entradas_x_fuente();
		});
			</script>
			<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
		
			
			<div id="grafico_evolucion_tags">
			
			<div id="graficos_modulos_4">
			
			</div>
		</div>

	<?php
}

function grafico_entradas_x_fuente_shortcode_trimestre()
{
	menu_periodos_estadisticas_fuente();
	?>
	<h3>TOP 10 - Entradas por fuente</h3>(Último Trimestre)
	
					<?php
					$sources = get_terms("fuente");
					//$colors=array('#330000','#660000','#990000','#b30000','#e60000','#ff3333','#ff6666','#ff9999','#ffb3b3','#ffcccc');
					//$colors=array('#01B8AA', '#374649', '#F2C80F', '#FD625E', '#A66999', '#DFBFBF', '#8AD4EB', '#FE9666', '#5F6B6D', '#AD514A', '#7BB252');
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $sources as $source ) {
					
					
						$args = array(
								'fuente'		   => $source->slug,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days')))
						);
					
					
						$query = new WP_Query( $args );
						$counter = 0;
						while ( $query->have_posts() ) : $query->the_post();
						$counter++;
						endwhile;
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$source->name);
							$myhashmap[$texto] = $counter;
					
						}
						wp_reset_postdata();
					}
					
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{	
			var grafica_entradas_x_fuente = function run_module_graphics_4()
			{	


				
				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 67
					    },
					chart: {
						renderTo: 'graficos_modulos_4_mes',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
		
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}
																	
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
									}
							
									
									
									?>
						

						]
				});						
			}
			grafica_entradas_x_fuente();
		});
			</script>
					<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
			
			<div id="grafico_evolucion_tags">
			
			<div id="graficos_modulos_4_mes">
			
			</div>
		</div>

	<?php
}


add_shortcode('grafico_entradas_x_concepto_trimestre','grafico_entradas_x_concepto_trimestre_shortcode');
function grafico_entradas_x_concepto_trimestre_shortcode (){
	menu_periodos_estadisticas_detalle();

	?>
	<br>
	<h3>TOP 10 - Entradas por concepto</h3>(Último Trimestre)
				<?php
					$categories = get_categories();
					//$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $categories as $category ) {
					
						$args = array(
								'category_name'    => $category->name,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days')))
						);
					
						$post_by_cat = get_posts($args);
						$counter = 0;
						foreach($post_by_cat as $p)
						{
							$counter++;
						}
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$category->name);
							$myhashmap[$texto] = $counter;
					
						}
					
					}
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	

	
				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 62
					    },
					chart: {
						renderTo: 'graficos_modulos_3_trimestre',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
					
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}									
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
									}
									
									?>
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>
			<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
	
	<div id="grafico_evolucion_tags">
	
	<div id="graficos_modulos_3_trimestre">
	
	</div>
</div>
<?php
}

add_shortcode('graficos_entradas_x_conceptos','graficos_entradas_x_conceptos_shortcode');
function graficos_entradas_x_conceptos_shortcode()
{
?>
<div  style="position:relative;width:49%;float:left;border-bottom:1px dotted grey;">
		<div id="grafico_semana" >
	<?php
	grafico_entradas_x_concepto_semana_shortcode();
	?>
	</div>
	<div id="grafico_mes" style="visibility:hidden;position:absolute;top:0;width:100%;">
		<?php
	grafico_entradas_x_concepto_mes_shortcode();
	?>
				</div>
				<div id="grafico_trimestre" style="visibility:hidden;position:absolute;top:0;width:100%;">
			<?php
	grafico_entradas_x_concepto_trimestre_shortcode();
	?>
				</div>
				</div>
			<?php
}
add_shortcode('grafico_entradas_x_concepto_semana','grafico_entradas_x_concepto_semana_shortcode');
function grafico_entradas_x_concepto_semana_shortcode (){
	menu_periodos_estadisticas_detalle();

	?>
	<br>
	<h3>TOP 10 - Entradas por concepto</h3> (Últimos 7 días)
				<?php
					$categories = get_categories();
					//$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $categories as $category ) {
					
						$args = array(
								'category_name'    => $category->name,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days')))
						);
					
						$post_by_cat = get_posts($args);
						$counter = 0;
						foreach($post_by_cat as $p)
						{
							$counter++;
						}
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$category->name);
							$myhashmap[$texto] = $counter;
					
						}
					
					}
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	

				
				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 62
					    },
					chart: {
						renderTo: 'graficos_modulos_sem',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
				
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}								
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
									}
									
									?>
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>

				<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
	<div id="grafico_evolucion_tags">
	
	<div id="graficos_modulos_sem">
	
	</div>
</div>


<?php
}
add_shortcode('grafico_entradas_x_concepto_mes','grafico_entradas_x_concepto_mes_shortcode');
function grafico_entradas_x_concepto_mes_shortcode (){
	menu_periodos_estadisticas_detalle();

	?>
	<br>
	<h3>TOP 10 - Entradas por concepto</h3>(Últimos 30 días)
				<?php
					$categories = get_categories();
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $categories as $category ) {
					
						$args = array(
								'category_name'    => $category->name,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-30 days')))
						);
					
						$post_by_cat = get_posts($args);
						$counter = 0;
						foreach($post_by_cat as $p)
						{
							$counter++;
						}
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$category->name);
							$myhashmap[$texto] = $counter;
					
						}
					
					}
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	


				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 62
					    },
					chart: {
						renderTo: 'graficos_modulos_mes',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
									
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}
									if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
									}
									
									?>
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>
			<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
	
	<div id="grafico_evolucion_tags">
	
	<div id="graficos_modulos_mes">
	
	</div>
</div>


<?php
}

add_shortcode('top_entradas','top_entradas_shortcode');
function top_entradas_shortcode(){
?>
	
		<?php
		
 									$categories = get_categories();
 									$myhashmap = array();
									foreach ( $categories as $category ) {
										
										$args = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days'))) 
										);
										
										$post_by_cat = get_posts($args);	
										$counter = 0;
										foreach($post_by_cat as $p)
										{
											$counter++;
										}
										
										if ($counter>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap[$texto] = $counter;
										}								
									}
									arsort($myhashmap);
									$temp_array=array_keys($myhashmap);
									$Key=$temp_array[0];
									
									return $Key.' <h2 style="display:inline">'.$myhashmap[$Key].'</h2>';

	?>	<?php
}

add_shortcode('estadistica_creciente','estadistica_creciente_shortcode');

function estadistica_creciente_shortcode(){
	$resultado=menu_periodos_estadisticas();
	$resultado=$resultado.'<div style="position:relative"><div id="est_semana"><h3>Tendencias</h3>Durante la última semana la tendencia más destacada es... <br>'.estadistica_creciente_semana_shortcode();
	$resultado=$resultado.'<i><br>(*) Variación del número de entradas respecto a la semana anterior </i>'.'</div>';
	$resultado=$resultado.'<div style="visibility:hidden;position:absolute;top:0;margin-bottom:5px;" id="est_mes"><h3>Tendencias</h3>Durante el último mes la tendencia más detacada es...<br>'.estadistica_creciente_mes_shortcode();
	$resultado=$resultado.'<i><br>(*) Variación del número de entradas respecto al mes anterior </i>'.'</div>';
	$resultado=$resultado.'<div style="visibility:hidden;position:absolute;top:0;margin-bottom:5px;" id="est_trimestre"><h3>Tendencias</h3>Durante el último año la tendencia más detacada es...<br>'.estadistica_creciente_trimestre_shortcode();
	$resultado=$resultado.'<i><br>(*) Variación del número de entradas respecto al año anterior </i>'.'</div></div>';
	$resultado=$resultado.'<div style="position:relative;height:25px;border:solid black 0px;"><div style="margin-right:5px;position:absolute;right:0px;top:0px;"><a href="'.get_site_url().'"><i>Ver más...</i></a></div></div>';
	return $resultado;

}
function estadistica_creciente_semana_shortcode(){
	?>
	
		<?php
 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
											'posts_per_page'=>-1,												
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-7 days')),'after' => date('Y-m-d', strtotime('-15 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);	
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{	
											echo $p->title;
											$counter_anterior++;
										}
										//if ($counter_actual>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_actual[$texto] = $counter_actual;
									//		echo 'ACTUAL: '.$texto.'-'.$counter_actual.'<br>';
										//}
										//if ($counter_anterior>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_anterior[$texto] = $counter_anterior;
											//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior.'<br>';
										//}
									
									}
									arsort($myhashmap_actual);								
									foreach (array_keys($myhashmap_actual) as $key){
									
										$diferencia=0;
										$valor_actual=0;
										$valor_anterior=0;
										$valor_actual=$myhashmap_actual[$key];
										$valor_anterior=$myhashmap_anterior[$key];
										//echo '----------'.$key.'----------'.'<br>';
										//echo 'VALOR_ACTUAL: '.$valor_actual.'<br>';
										//echo '---VALOR_ANTERIOR: '.$valor_anterior.'<br>';
									
											if($myhashmap_anterior[$key]>0){
											
										
												$diferencia=($valor_actual-$valor_anterior);
												$myhashmap_diferencia_ABS[$key]=$diferencia;
												
											//	echo 'diferencia1:'.$myhashmap_diferencia_ABS[$key];
											
												$diferencia=$diferencia/$valor_anterior;
												
												$myhashmap_diferencia[$key]=$diferencia*100;
												//echo 'diferencia2:'.$myhashmap_diferencia[$key];
											}else{
												if($myhashmap_actual[$key]>0){
													$myhashmap_diferencia[$key]=100;
													$myhashmap_diferencia_ABS[$key]=$valor_actual;
													}else{
														$myhashmap_diferencia[$key]=0;
														$myhashmap_diferencia_ABS[$key]=0;
													}
										
											}
										
								
									}
									arsort($myhashmap_diferencia_ABS);
									$temp_key_max=array_keys($myhashmap_diferencia_ABS);
									$key_max=$temp_key_max[0];
									asort($myhashmap_diferencia_ABS);
									$temp_key_min=array_keys($myhashmap_diferencia_ABS);
									$key_min=$temp_key_min[0];
									
									$_string_max='<div style="margin-right:5px;display:inline;"><i class="fa fa-sort-asc" style="font-size:32px;color:#98DF58;padding:3px;"></i>'.$key_max.' <h2 style="display:inline">+'.$myhashmap_diferencia_ABS[$key_max].'</h2>('.$myhashmap_diferencia[$key_max].'% )</div>';

									$_string_min='<i class="fa fa fa-sort-down" style="font-size:32px;color:#EC6464;padding:3px;margin-left:10px;"></i> '.$key_min.' <h2 style="display:inline">'.$myhashmap_diferencia_ABS[$key_min].'</h2>('.$myhashmap_diferencia[$key_min].'% ) ';
									
								//	$string_tendencia_semana='<h3>Tendencias</h3>(Últimos 7 días)';
									$string_tendencia_semana=$_string_max;
									if($myhashmap_diferencia[$key_min]<0){
										$string_tendencia_semana=$_string_max.' | '.$_string_min;
									}
									return $string_tendencia_semana;

	?><?php
}

function estadistica_creciente_mes_shortcode(){
	?>

		<?php
 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-30 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-30 days')),'after' => date('Y-m-d', strtotime('-60 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);	
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{	
											echo $p->title;
											$counter_anterior++;
										}
										//if ($counter_actual>0){
										$texto=str_replace("'","\'",$category->name);
										$myhashmap_actual[$texto] = $counter_actual;
										//		echo 'ACTUAL: '.$texto.'-'.$counter_actual.'<br>';
										//}
										//if ($counter_anterior>0){
										$texto=str_replace("'","\'",$category->name);
										$myhashmap_anterior[$texto] = $counter_anterior;
										//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior.'<br>';
										//}
											
										}
										arsort($myhashmap_actual);
										foreach (array_keys($myhashmap_actual) as $key){
												
											$diferencia=0;
											$valor_actual=0;
											$valor_anterior=0;
											$valor_actual=$myhashmap_actual[$key];
											$valor_anterior=$myhashmap_anterior[$key];
											//echo '----------'.$key.'----------'.'<br>';
											//echo 'VALOR_ACTUAL: '.$valor_actual.'<br>';
											//echo '---VALOR_ANTERIOR: '.$valor_anterior.'<br>';
												
											if($myhashmap_anterior[$key]>0){
													
										
												$diferencia=($valor_actual-$valor_anterior);
												$myhashmap_diferencia_ABS[$key]=$diferencia;
										
												//	echo 'diferencia1:'.$myhashmap_diferencia_ABS[$key];
													
												$diferencia=$diferencia/$valor_anterior;
										
												$myhashmap_diferencia[$key]=$diferencia*100;
												//echo 'diferencia2:'.$myhashmap_diferencia[$key];
											}else{
												if($myhashmap_actual[$key]>0){
													$myhashmap_diferencia[$key]=100;
													$myhashmap_diferencia_ABS[$key]=$valor_actual;
												}else{
													$myhashmap_diferencia[$key]=0;
													$myhashmap_diferencia_ABS[$key]=0;
												}
										
											}
										
										
										}
										arsort($myhashmap_diferencia_ABS);
										$temp_key_max=array_keys($myhashmap_diferencia_ABS);
										$key_max=$temp_key_max[0];
										asort($myhashmap_diferencia_ABS);
										$temp_key_min=array_keys($myhashmap_diferencia_ABS);
										$key_min=$temp_key_min[0];
											
									
									$_string_max='<div style="margin-right:5px;display:inline;"><i class="fa fa-sort-asc" style="font-size:32px;color:#98DF58;padding:3px;"></i>'.$key_max.' <h2 style="display:inline">+'.$myhashmap_diferencia_ABS[$key_max].'</h2>('.$myhashmap_diferencia[$key_max].'% )</div>';

									$_string_min='<i class="fa fa fa-sort-down" style="font-size:32px;color:#EC6464;padding:3px;margin-left:10px;"></i> '.$key_min.' <h2 style="display:inline">'.$myhashmap_diferencia_ABS[$key_min].'</h2>('.$myhashmap_diferencia[$key_min].'% ) ';
									
									$string_tendencia_semana=$_string_max;
									if($myhashmap_diferencia[$key_min]<0){
										$string_tendencia_semana=$_string_max.' | '.$_string_min;
									}
									return $string_tendencia_semana;

	?><?php
}
function estadistica_creciente_trimestre_shortcode(){
	?>
		
		<?php
 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-90 days')),'after' => date('Y-m-d', strtotime('-180 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);	
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{	
											echo $p->title;
											$counter_anterior++;
										}
										
										//if ($counter_actual>0){
										$texto=str_replace("'","\'",$category->name);
										$myhashmap_actual[$texto] = $counter_actual;
										//		echo 'ACTUAL: '.$texto.'-'.$counter_actual.'<br>';
										//}
										//if ($counter_anterior>0){
										$texto=str_replace("'","\'",$category->name);
										$myhashmap_anterior[$texto] = $counter_anterior;
										//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior.'<br>';
										//}
											
										}
										arsort($myhashmap_actual);
										foreach (array_keys($myhashmap_actual) as $key){
										
											$diferencia=0;
											$valor_actual=0;
											$valor_anterior=0;
											$valor_actual=$myhashmap_actual[$key];
											$valor_anterior=$myhashmap_anterior[$key];
											//echo '----------'.$key.'----------'.'<br>';
											//echo 'VALOR_ACTUAL: '.$valor_actual.'<br>';
											//echo '---VALOR_ANTERIOR: '.$valor_anterior.'<br>';
										
											if($myhashmap_anterior[$key]>0){
													
										
												$diferencia=($valor_actual-$valor_anterior);
												$myhashmap_diferencia_ABS[$key]=$diferencia;
										
												//	echo 'diferencia1:'.$myhashmap_diferencia_ABS[$key];
													
												$diferencia=$diferencia/$valor_anterior;
										
												$myhashmap_diferencia[$key]=$diferencia*100;
												//echo 'diferencia2:'.$myhashmap_diferencia[$key];
											}else{
												if($myhashmap_actual[$key]>0){
													$myhashmap_diferencia[$key]=100;
													$myhashmap_diferencia_ABS[$key]=$valor_actual;
												}else{
													$myhashmap_diferencia[$key]=0;
													$myhashmap_diferencia_ABS[$key]=0;
												}
										
											}
										
										
										}
										arsort($myhashmap_diferencia_ABS);
										$temp_key_max=array_keys($myhashmap_diferencia_ABS);
										$key_max=$temp_key_max[0];
										asort($myhashmap_diferencia_ABS);
										$temp_key_min=array_keys($myhashmap_diferencia_ABS);
										$key_min=$temp_key_min[0];
											
									
									$_string_max='<div style="margin-right:5px;display:inline;"><i class="fa fa-sort-asc" style="font-size:32px;color:#98DF58;padding:3px;"></i>'.$key_max.' <h2 style="display:inline">+'.$myhashmap_diferencia_ABS[$key_max].'</h2>('.$myhashmap_diferencia[$key_max].'% )</div>';

									$_string_min='<i class="fa fa fa-sort-down" style="font-size:32px;color:#EC6464;padding:3px;margin-left:10px;"></i> '.$key_min.' <h2 style="display:inline">'.$myhashmap_diferencia_ABS[$key_min].'</h2>('.$myhashmap_diferencia[$key_min].'% ) ';
									
									$string_tendencia_semana=$_string_max;
									if($myhashmap_diferencia[$key_min]<0){
										$string_tendencia_semana=$_string_max.' | '.$_string_min;
									}
									
									return $string_tendencia_semana;

	?><?php
}

function menu_periodos_estadisticas(){
	$html='<div id="menu_periodos_estadisticas" style="margin-top:5px;"><a <a style="margin-left:5px;margin-right:5px;" id="myLink_week" href="#" onclick="showLastSevenDays();">últimos 7 días</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_month" href="#" onclick="showLastThirtyDays();">último mes</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_tri" href="#" onclick="showLastNinetyDays();">último trimestre</a></div>';
	
	return $html;
	
}
	

/****************DETALLE ESTADISTICAS*******************/
add_shortcode('estadistica_creciente_detalle','estadistica_creciente_detalle_shortcode');

function estadistica_creciente_detalle_shortcode(){
	//$resultado=menu_periodos_estadisticas_detalle();
	$hashmapSemana=estadistica_creciente_semana_detalle_shortcode();
	$div_semana='graficos_evolucion_3_semana';
	$subtitle_semana='(Últimos 7 días)';
	
	$hashmapMes=estadistica_creciente_mes_detalle_shortcode();
	$div_mes='graficos_evolucion_3_mes';
	$subtitle_mes='(Últimos 30 días)';
	
	$hashmapTrimestre=estadistica_creciente_trimestre_detalle_shortcode();
	$div_trimestre='graficos_evolucion_3_trimestre';
	$subtitle_trimestre='(Último trimestre)';
	?>
	

	<div style="position:relative;width:50%;float:left;border-bottom:1px dotted grey;border-left:1px dotted grey;padding-left: 10px;  "><div id="est_semana_detalle">	<?php grafico_evolucion_conceptos_trimestre($hashmapSemana,$div_semana,$subtitle_semana) ?></div>
	<div style="visibility:hidden;position:absolute;top:0; width:100%;   border: 0px solid red;" id="est_mes_detalle"><?php grafico_evolucion_conceptos_trimestre($hashmapMes,$div_mes,$subtitle_mes) ?></div>
	<div style="visibility:hidden;position:absolute;top:0; width:100%;   border: 0px solid blue;" id="est_trimestre_detalle"><?php grafico_evolucion_conceptos_trimestre($hashmapTrimestre,$div_trimestre,$subtitle_trimestre) ?></div></div>
	
	<?php
	

}
function estadistica_creciente_semana_detalle_shortcode(){

 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_anterior = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
 									
 									$myhashmap_anterior_filtrado = array();
 									$myhashmap_actual_filtrado = array();
 									$hmTotal = array();
 									
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-4 days')),'after' => date('Y-m-d', strtotime('-20 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);	
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{	
											//echo $p->title;
											$counter_anterior++;
										}
										if ($counter_actual>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_actual[$texto] = $counter_actual;
											//echo 'ACTUAL: '.$texto.'-'.$counter_actual;
										}
										if ($counter_anterior>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_anterior[$texto] = $counter_anterior;
											//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior;
										}
									
									}
									arsort($myhashmap_actual);	
									$max_results=0;
									foreach (array_keys($myhashmap_actual) as $key){
										//if($max_results>9){
										//	break;
										//}
										$diferencia=0;
										$valor_actual=0;
										$valor_anterior=0;
										$valor_actual=$myhashmap_actual[$key];
										$valor_anterior=$myhashmap_anterior[$key];
										if($myhashmap_anterior[$key]>0){
										
											//echo '----------'.$key.'----------';
											//echo 'VALOR_ACTUAL: '.$valor_actual;
										    //echo '---VALOR_ANTERIOR: '.$valor_anterior;
											$diferencia=($valor_actual-$valor_anterior);
											if ($diferencia >= 0){
												$myhashmap_diferencia_ABS[$key]=$diferencia;											
												$diferencia=$diferencia/$valor_anterior;
												//echo 'diferencia2:'.$diferencia;
												$myhashmap_diferencia[$key]=$diferencia*100;
											}
										
										}else{
											$myhashmap_diferencia[$key]=100;
											$myhashmap_diferencia_ABS[$key]=$valor_actual;
										}
						
									}
									arsort($myhashmap_diferencia_ABS);
									$_string_min='';
									$max_results=0;
								
									foreach (array_keys($myhashmap_diferencia_ABS) as $key){
										//echo '----------'.$key.'----------';
										if($max_results>9){
											break;
										}
										$myhashmap_anterior_filtrado[$key]=$myhashmap_anterior[$key];
										$myhashmap_actual_filtrado[$key]=$myhashmap_actual[$key];
										$max_results=$max_results+1;
										if($myhashmap_diferencia[$key]<0){
									
											$_string_min=$_string_min.'<i class="fa fa fa-sort-down" style="font-size:30px;color:#EC6464;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
												
										}else {
										
											$_string_min=$_string_min.'<i class="fa fa-sort-asc" style="font-size:30px;color:#98DF58;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
												
										}
									}
									
									arsort($myhashmap_actual_filtrado);
								
									$hmTotal['anterior']=$myhashmap_anterior_filtrado;
									$hmTotal['actual']=$myhashmap_actual_filtrado;
									$hmTotal['diferencia']=$myhashmap_diferencia_ABS;
									return $hmTotal;
										
									//return $_string_min;
									//return $myhashmap_diferencia_ABS;

	?><?php
}

function estadistica_creciente_mes_detalle_shortcode(){
	?>

		<?php
 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
 									
 									$myhashmap_anterior_filtrado = array();
 									$myhashmap_actual_filtrado = array();
 									$hmTotal = array();
 									
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-30 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-30 days')),'after' => date('Y-m-d', strtotime('-60 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{
											//echo $p->title;
											$counter_anterior++;
										}
										if ($counter_actual>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_actual[$texto] = $counter_actual;
											//echo 'ACTUAL: '.$texto.'-'.$counter_actual;
										}
										if ($counter_anterior>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_anterior[$texto] = $counter_anterior;
											//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior;
										}
											
										}
										arsort($myhashmap_actual);
										$max_results=0;
										foreach (array_keys($myhashmap_actual) as $key){
											//if($max_results>9){
											//	break;
											//}
											$diferencia=0;
											$valor_actual=0;
											$valor_anterior=0;
											$valor_actual=$myhashmap_actual[$key];
											$valor_anterior=$myhashmap_anterior[$key];
											if($myhashmap_anterior[$key]>0){
										
												//echo '----------'.$key.'----------';
												//echo 'VALOR_ACTUAL: '.$valor_actual;
												//echo '---VALOR_ANTERIOR: '.$valor_anterior;
												$diferencia=($valor_actual-$valor_anterior);
												if ($diferencia >= 0){
													$myhashmap_diferencia_ABS[$key]=$diferencia;
													$diferencia=$diferencia/$valor_anterior;
													//echo 'diferencia2:'.$diferencia;
													$myhashmap_diferencia[$key]=$diferencia*100;
												}
										
											}else{
												$myhashmap_diferencia[$key]=100;
												$myhashmap_diferencia_ABS[$key]=$valor_actual;
											}
											
										}
										arsort($myhashmap_diferencia_ABS);
										$_string_min='';
											
										$max_results=0;
										foreach (array_keys($myhashmap_diferencia_ABS) as $key){
											//echo '----------'.$key.'----------';
											if($max_results>9){
												break;
											}
											$myhashmap_anterior_filtrado[$key]=$myhashmap_anterior[$key];
											$myhashmap_actual_filtrado[$key]=$myhashmap_actual[$key];
											$max_results=$max_results+1;
											if($myhashmap_diferencia[$key]<0){
													
												$_string_min=$_string_min.'<i class="fa fa fa-sort-down" style="font-size:30px;color:#EC6464;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
										
											}else {
										
												$_string_min=$_string_min.'<i class="fa fa-sort-asc" style="font-size:30px;color:#98DF58;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
										
											}
										}
											
										arsort($myhashmap_actual_filtrado);
										
										$hmTotal['anterior']=$myhashmap_anterior_filtrado;
										$hmTotal['actual']=$myhashmap_actual_filtrado;
										$hmTotal['diferencia']=$myhashmap_diferencia_ABS;
										return $hmTotal;

	?><?php
}
function estadistica_creciente_trimestre_detalle_shortcode(){
	?>
	
		<?php
 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
 									
 									$myhashmap_anterior_filtrado = array();
 									$myhashmap_actual_filtrado = array();
 									$hmTotal = array();
 									
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-90 days')),'after' => date('Y-m-d', strtotime('-180 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{
											//echo $p->title;
											$counter_anterior++;
										}
										if ($counter_actual>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_actual[$texto] = $counter_actual;
											//echo 'ACTUAL: '.$texto.'-'.$counter_actual;
										}
										if ($counter_anterior>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_anterior[$texto] = $counter_anterior;
											//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior;
										}
											
										}
										arsort($myhashmap_actual);
										$max_results=0;
										foreach (array_keys($myhashmap_actual) as $key){
											//if($max_results>9){
											//	break;
											//}
											$diferencia=0;
											$valor_actual=0;
											$valor_anterior=0;
											$valor_actual=$myhashmap_actual[$key];
											$valor_anterior=$myhashmap_anterior[$key];
											if($myhashmap_anterior[$key]>0){
										
											
												$diferencia=($valor_actual-$valor_anterior);
												if ($diferencia >= 0){
													//echo '----------'.$key.'----------';
													//echo 'VALOR_ACTUAL: '.$valor_actual;
													//echo '---VALOR_ANTERIOR: '.$valor_anterior;
													$myhashmap_diferencia_ABS[$key]=$diferencia;
													$diferencia=$diferencia/$valor_anterior;
													//echo 'diferencia2:'.$diferencia;
													$myhashmap_diferencia[$key]=$diferencia*100;
												}
										
											}else{
												$myhashmap_diferencia[$key]=100;
												$myhashmap_diferencia_ABS[$key]=$valor_actual;
											}
											
										}
										arsort($myhashmap_diferencia_ABS);
										$_string_min='';
										$max_results=0;
										
										foreach (array_keys($myhashmap_diferencia_ABS) as $key){
											//echo '----------'.$key.'----------';
											if($max_results>9){
												break;
											}
											//echo '**** '.$key.'----------';
											//echo '******** VALOR_ACTUAL: '.$valor_actual;
											//echo '***VALOR_ANTERIOR: '.$valor_anterior;
											$myhashmap_anterior_filtrado[$key]=$myhashmap_anterior[$key];
											$myhashmap_actual_filtrado[$key]=$myhashmap_actual[$key];
											$max_results=$max_results+1;
											if($myhashmap_diferencia[$key]<0){
													
												$_string_min=$_string_min.'<i class="fa fa fa-sort-down" style="font-size:30px;color:#EC6464;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
										
											}else {
										
												$_string_min=$_string_min.'<i class="fa fa-sort-asc" style="font-size:30px;color:#98DF58;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
										
											}
										}
											
										arsort($myhashmap_actual_filtrado);
										
										$hmTotal['anterior']=$myhashmap_anterior_filtrado;
										$hmTotal['actual']=$myhashmap_actual_filtrado;
										$hmTotal['diferencia']=$myhashmap_diferencia_ABS;
										return $hmTotal;

	?><?php
}

function menu_periodos_estadisticas_detalle(){
	$html='<div id="menu_periodos_estadisticas"><a <a style="margin-right:5px;" id="myLink_week" href="#" onclick="showLastSevenDaysDetail();">últimos 7 días</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_month" href="#" onclick="showLastThirtyDaysDetail();">último mes</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_tri" href="#" onclick="showLastNinetyDaysDetail();">último trimestre</a></div>';
	
	echo $html;
	
}

function menu_periodos_estadisticas_fuente(){
	//genera_array_ultimos_doce_meses();
	
	$html='<div id="menu_periodos_estadisticas"><a <a style="margin-right:5px;" id="myLink_week" href="#" onclick="showLastSevenDaysSources();">últimos 7 días</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_month" href="#" onclick="showLastThirtyDaysSources();">último mes</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_tri" href="#" onclick="showLastNinetyDaysSources();">último trimestre</a></div>';

	echo $html;

}

function genera_array_ultimos_doce_meses(){
	$previo=0;
	$doce_meses=array('','','','','','','','','','','','');
	$strMes='[';
	$primero=0;
	foreach ($doce_meses as &$mes) {
		$mes=date('M', strtotime("first day of".$previo. "month"));
		if($primero>0){
			$strMes=$strMes.',';
		}
		$strMes=$strMes.'\''.$mes.'\'';
		$previo=$previo-1;
		$primero=$primero+1;
	}
	$strMes=$strMes.']';
	return $strMes;

}
add_shortcode('grafico_evolucion_anual_conceptos','grafico_evolucion_anual_conceptos_shortcode');
function grafico_evolucion_anual_conceptos_shortcode(){
	?>
	<div >
		<br>
		<h3>Evolución anual conceptos</h3>
	
		<script>
			jQuery(document).ready(function run_module_graphics($)
			{
		var grafica_entradas_x_tags = function run_module_graphics_4(){	
					<?php
						$categories = get_categories();
						//$colors=array('#000000','#661400','#991f00','#cc2900','#ff471a','#ff704d','#ff8566','#ff9980','#ffc2b3','#ffd6cc',' #ffebe6',' #f8dbd3');
						$colors= get_color_sequence();
						$color_index=0;
					?>
					
					var chart3 = new Highcharts.Chart({
						   legend: {
						        align: 'left',
						        verticalAlign: 'top',
						        layout: 'vertical',
						        x: 0,
						        y: 62
						    },
						chart: {
							renderTo: 'graficos_modulos_anyo',
							type: 'line',
							options3d: {
								enabled: true,
								alpha: 45
							}
						},
						exporting: { enabled: false },
						title: {
							text: null
						},  xAxis: {
					        categories: <?php echo genera_array_ultimos_doce_meses();?>
					    },
						 yAxis: {
				            min: 0,
				            title: {
				                text: 'Número de entradas',
				   
				            },
				            labels: {
				                overflow: 'justify'
				            }
				        },
						series: [
				
							<?php
										$first=0;
										$myhashmap = array();
						
										foreach ( $categories as $category ) {
									
											$args = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
													'posts_per_page'=>-1,
												'date_query'	   => array('after' => date('Y-m-d', strtotime('-365 days'))) 
											);
											
											$post_by_cat = get_posts($args);	
											$counter = 0;
											foreach($post_by_cat as $p)
											{
												$counter++;
											}
											
											if ($counter>0){
	
											$texto=str_replace("'","\'",$category->name);
											$myhashmap[$texto] = $counter;
	
											}
									
										}
										arsort($myhashmap);
										$max_results=0;
										foreach (array_keys($myhashmap) as $key){
											if($max_results>9){
												break;
											}
											if($max_results>0){
												echo ',';
											}
								
											echo '{name:\''.$key.'\',data:'. get_evolution_serie_category($key).',color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
											
										}
										
										?>
							]
					});						
				}
			grafica_entradas_x_tags();
	});
		</script>
	
		
		<div id="grafico_evolucion_tags">
		
		<div id="graficos_modulos_anyo">
		
		</div>
	</div>
		</div>
	
	
	<?php
}
function get_evolution_serie_category($category){
	//echo date('Y-m-d', strtotime("last day of 0 month"));
	$previo=-1;
	$entradas_mes=array('','','','','','','','','','','','');
	$strEntradasMes='[';
	foreach ($entradas_mes as &$num_entradas) {
		if($previo<-1){
			//echo ' previo -1)';
			$strEntradasMes=$strEntradasMes.',';
			$args = array(
					'category_name'    => $category,
					'post_type'        => 'post',
					'post_status'      => 'publish',
					'suppress_filters' => true,
					'posts_per_page'=>-1,
					'date_query'	   => array('after' => date('Y-m-d', strtotime("last day of".($previo-1). "month")),
							'before' => date('Y-m-d', strtotime("first day of".($previo+1). "month")))
			);
		}else{
			//echo 'ELSE)';
			$args = array(
					'category_name'    => $category,
					'post_type'        => 'post',
					'post_status'      => 'publish',
					'suppress_filters' => true,
					'posts_per_page'=>-1,
					'date_query'	   => array('after' => date('Y-m-d', strtotime("last day of -1 month")))
			);
		}
		//echo  strtotime("last day of".($previo));
		//echo  strtotime("first day of".($previo+1));
	
		/*echo('------------');
		echo('date_ini: '.date('Y-m-d', strtotime("last day of".($previo). "month")));
		echo('date_end: '.date('Y-m-d', strtotime("first day of".($previo+1). "month")));*/
		$post_by_cat = get_posts($args);
		//echo $post_by_cat->request;
		$counter = 0;
		foreach($post_by_cat as $p)
		{
			$counter++;
		}
		$num_entradas=$counter;
		$strEntradasMes=$strEntradasMes.$counter;
	//	echo '--'.$num_entradas.'---';
		$previo=$previo-1;
	}
	$strEntradasMes=$strEntradasMes.']';
	return $strEntradasMes;
}
 
 
 
 /***************************************/
function grafico_evolucion_conceptos_trimestre($myhashmap,$div,$subtitlePeriod){
	$myhashmap_anterior = $myhashmap['anterior'];
	$myhashmap_actual= $myhashmap['actual'];

	?>
	<br>
	<h3>Evolución Entradas por concepto</h3><?php echo $subtitlePeriod ?>
	<br>
	<i>Se muestran los incrementos en el número de impactos más relevantes.</i>

	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	
				<?php
					//$categories = get_categories();
					$colors=  get_color_sequence();
				//	$colors_negative=  get_negative_color_sequence();
					$color_index=0;
					$data_actual='';
					$data_anterior='';
				?>
				//$('#graficos_modulos_3').css('border','1px solid #999');
				//$('#graficos_modulos_3').css('box-shadow','2px 2px 10px #999');
				//$('#graficos_modulos_3').css('width','1003px');
				
				var chart3 = new Highcharts.Chart({
				
					chart: {
						renderTo: '<?php echo $div ?>',
						type: 'column',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas'
			          
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
			        xAxis:{
				        	categories: [<?php 
					        	$max_results=0;
					        	foreach (array_keys($myhashmap_actual) as $key){
					        		if($max_results>9){
					        			break;
					        		}
					        		if ($first>0){
					        			echo ',';
					        			$data_actual=$data_actual.',';
					        			$data_anterior = $data_anterior.',';
					        		}
					        		
					        		if (array_key_exists (  $key ,$myhashmap_actual)){
					        			$data_actual = $data_actual.$myhashmap_actual[$key];
					        		} else {
					        			$data_actual = $data_actual.'0';
					        		}
					        		
					        		if ($myhashmap_anterior[$key]<>''){
					        			$data_anterior = $data_anterior.$myhashmap_anterior[$key];
					        		} else {
					        			$data_anterior = $data_anterior.'0';
					        		}
					        	
					        
					        		echo '\''.$key.'\'';
					        	
					        		$first=$first+1;
					        		$max_results=$max_results+1;
					        	}
					        	?>


					        	]},
				            plotOptions: {
				                column: {
				                    grouping: false,
				                    shadow: false,
				                    borderWidth: 0,
				                    dataLabels: {
				                        enabled: true,
				                        color: 'gray'
				                    }
				                }
				                
				            },    tooltip: {
				                shared: true
				            },
					series: [{
						name: 'Periodo actual',
						color: <?php echo '\''.$colors[4].'\'';?>,
						data: [	<?php echo $data_actual;?>],
						pointPadding:0.2,
						pointPlacement:-0},
						{
							name: 'Periodo anterior',
							color: <?php echo '\''.$colors[7].'\''; ?>,
							data: 	[<?php echo $data_anterior;?>],
							pointPadding:0.3,
							pointPlacement:0}
				
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>

	
	<div id="grafico_evolucion_tags">
	
	<div id="<?php echo $div ?>">
	
	</div>
</div>
<?php
}